<?php

namespace Laravel\Nightwatch\Records;

use Laravel\Nightwatch\LazyValue;
use Laravel\Nightwatch\Types\Str;

/**
 * @internal
 */
final class Command extends Record
{
    public int $v = 1;

    public string $t = 'command';

    /**
     * TODO limit size of all int values across all record types.
     *
     * @param  string|LazyValue<string>  $trace_id
     */
    public function __construct(
        public float $timestamp,
        public string $deploy,
        public string $server,
        public string $_group,
        public string|LazyValue $trace_id,
        // --- //
        public string $class,
        public string $name,
        public string $command,
        public int $exit_code,
        public int $duration,
        public int $bootstrap,
        public int $action,
        public int $terminating,
        // --- //
        public int $exceptions,
        public int $logs,
        public int $queries,
        public int $lazy_loads,
        public int $jobs_queued,
        public int $mail,
        public int $notifications,
        public int $outgoing_requests,
        public int $files_read,
        public int $files_written,
        public int $cache_events,
        public int $hydrated_models,
        public int $peak_memory_usage,
        public string $exception_preview,
    ) {
        $this->class = Str::text($this->class);
        $this->name = Str::tinyText($this->name);
        $this->command = Str::text($this->command);
        $this->exception_preview = Str::tinyText($this->exception_preview);
    }
}
