import { isAttributeEquals } from '@primeuix/utils/dom';
import BaseDirective from '@primevue/core/basedirective';
import KeyFilterStyle from 'primevue/keyfilter/style';

var BaseKeyFilter = BaseDirective.extend({
  style: KeyFilterStyle
});

var KeyFilter = BaseKeyFilter.extend('keyfilter', {
  beforeMount: function beforeMount(el, options) {
    var target = this.getTarget(el);
    if (!target) return;
    target.$_pkeyfilterModifier = this.getModifiers(options);
    if (options.value !== undefined) {
      var _options$value, _options$value2;
      target.$_pkeyfilterPattern = ((_options$value = options.value) === null || _options$value === void 0 ? void 0 : _options$value.pattern) || options.value;
      target.$_pkeyfilterValidateOnly = ((_options$value2 = options.value) === null || _options$value2 === void 0 ? void 0 : _options$value2.validateOnly) || false;
    }
    this.bindEvents(target);
    target.setAttribute('data-pd-keyfilter', true);
  },
  updated: function updated(el, options) {
    var target = this.getTarget(el);
    if (!target) return;
    target.$_pkeyfilterModifier = this.getModifiers(options);
    this.unbindEvents(el, options);
    if (options.value !== undefined) {
      var _options$value3, _options$value4;
      target.$_pkeyfilterPattern = ((_options$value3 = options.value) === null || _options$value3 === void 0 ? void 0 : _options$value3.pattern) || options.value;
      target.$_pkeyfilterValidateOnly = ((_options$value4 = options.value) === null || _options$value4 === void 0 ? void 0 : _options$value4.validateOnly) || false;
    }
    this.bindEvents(target);
  },
  unmounted: function unmounted(el, options) {
    this.unbindEvents(el, options);
  },
  DEFAULT_PATTERNS: {
    pint: /[\d]/,
    "int": /[\d-]/,
    pnum: /[\d.]/,
    money: /[\d.\s,]/,
    num: /[\d-.]/,
    hex: /[0-9a-f]/i,
    email: /[a-z0-9_.-@]/i,
    alpha: /[a-z_]/i,
    alphanum: /[a-z0-9_]/
  },
  methods: {
    getTarget: function getTarget(el) {
      return isAttributeEquals(el, 'data-pc-name', 'inputtext') || isAttributeEquals(el, 'data-pc-name', 'textarea') ? el : null;
    },
    getModifiers: function getModifiers(options) {
      if (options.modifiers && Object.keys(options.modifiers).length) {
        return Object.keys(options.modifiers)[Object.keys(options.modifiers).length - 1];
      }
      return '';
    },
    getRegex: function getRegex(target) {
      return target.$_pkeyfilterPattern ? target.$_pkeyfilterPattern : target.$_pkeyfilterModifier ? this.DEFAULT_PATTERNS[target.$_pkeyfilterModifier] : /./;
    },
    bindEvents: function bindEvents(el) {
      var _this = this;
      el.$_keyfilterKeydownEvent = function (event) {
        return _this.onKeydown(event, el);
      };
      el.$_keyfilterPasteEvent = function (event) {
        return _this.onPaste(event, el);
      };
      el.$_keyfilterInputEvent = function (event) {
        return _this.onInput(event, el);
      };
      el.addEventListener('keypress', el.$_keyfilterKeydownEvent);
      el.addEventListener('paste', el.$_keyfilterPasteEvent);
      el.addEventListener('input', el.$_keyfilterInputEvent);
    },
    unbindEvents: function unbindEvents(el) {
      el.removeEventListener('keypress', el.$_keyfilterKeydownEvent);
      el.removeEventListener('paste', el.$_keyfilterPasteEvent);
      el.removeEventListener('input', el.$_keyfilterInputEvent);
      el.$_keyfilterKeydownEvent = null;
      el.$_keyfilterPasteEvent = null;
      el.$_keyfilterInputEvent = null;
    },
    onInput: function onInput(event, target) {
      var regex = this.getRegex(target);
      if (regex && !regex.test(target.value)) {
        // remove invalid character e.g. ~ "
        target.value = target.value.slice(0, -1);
      }
    },
    onKeydown: function onKeydown(event, target) {
      if (event.ctrlKey || event.altKey || event.metaKey || event.key === 'Tab') {
        return;
      }
      var regex = this.getRegex(target);
      if (regex === '') {
        return;
      }
      var testKey = "".concat(event.key);
      if (target.$_pkeyfilterValidateOnly) {
        testKey = "".concat(target.value.substring(0, target.selectionStart)).concat(event.key).concat(target.value.substring(target.selectionEnd));
      }
      if (!regex.test(testKey)) {
        // runs before @update:modelValue emit
        event.preventDefault();
      }
    },
    onPaste: function onPaste(event, target) {
      var regex = this.getRegex(target);
      if (regex === '') {
        return;
      }
      var clipboard = event.clipboardData.getData('text');
      if (target.$_pkeyfilterValidateOnly) {
        var newValue = "".concat(target.value.substring(0, target.selectionStart)).concat(clipboard).concat(target.value.substring(target.selectionEnd));
        if (!regex.test(newValue)) {
          event.preventDefault();
        }
      } else {
        for (var i = 0; i < clipboard.length; i++) {
          if (!regex.test(clipboard[i])) {
            event.preventDefault();
            return;
          }
        }
      }
    }
  }
});

export { KeyFilter as default };
//# sourceMappingURL=index.mjs.map
