import { setAttribute, find, scrollInView } from '@primeuix/utils/dom';
import { isEmpty, findIndexInList } from '@primeuix/utils/object';
import AngleDoubleDownIcon from '@primevue/icons/angledoubledown';
import AngleDoubleLeftIcon from '@primevue/icons/angledoubleleft';
import AngleDoubleRightIcon from '@primevue/icons/angledoubleright';
import AngleDoubleUpIcon from '@primevue/icons/angledoubleup';
import AngleDownIcon from '@primevue/icons/angledown';
import AngleLeftIcon from '@primevue/icons/angleleft';
import AngleRightIcon from '@primevue/icons/angleright';
import AngleUpIcon from '@primevue/icons/angleup';
import Button from 'primevue/button';
import Listbox from 'primevue/listbox';
import Ripple from 'primevue/ripple';
import BaseComponent from '@primevue/core/basecomponent';
import PickListStyle from 'primevue/picklist/style';
import { resolveComponent, createElementBlock, openBlock, mergeProps, createCommentVNode, createElementVNode, renderSlot, createVNode, withCtx, createSlots, createBlock, resolveDynamicComponent } from 'vue';

var script$1 = {
  name: 'BasePickList',
  "extends": BaseComponent,
  props: {
    modelValue: {
      type: Array,
      "default": function _default() {
        return [[], []];
      }
    },
    selection: {
      type: Array,
      "default": function _default() {
        return [[], []];
      }
    },
    dataKey: {
      type: String,
      "default": null
    },
    listStyle: {
      type: null,
      "default": null
    },
    metaKeySelection: {
      type: Boolean,
      "default": false
    },
    autoOptionFocus: {
      type: Boolean,
      "default": true
    },
    focusOnHover: {
      type: Boolean,
      "default": true
    },
    responsive: {
      type: Boolean,
      "default": true
    },
    breakpoint: {
      type: String,
      "default": '960px'
    },
    striped: {
      type: Boolean,
      "default": false
    },
    scrollHeight: {
      type: String,
      "default": '14rem'
    },
    showSourceControls: {
      type: Boolean,
      "default": true
    },
    showTargetControls: {
      type: Boolean,
      "default": true
    },
    buttonProps: {
      type: Object,
      "default": function _default() {
        return {
          severity: 'secondary'
        };
      }
    },
    moveUpButtonProps: {
      type: null,
      "default": null
    },
    moveTopButtonProps: {
      type: null,
      "default": null
    },
    moveDownButtonProps: {
      type: null,
      "default": null
    },
    moveBottomButtonProps: {
      type: null,
      "default": null
    },
    moveToTargetProps: {
      type: null,
      "default": null
    },
    moveAllToTargetProps: {
      type: null,
      "default": null
    },
    moveToSourceProps: {
      type: null,
      "default": null
    },
    moveAllToSourceProps: {
      type: null,
      "default": null
    },
    tabindex: {
      type: Number,
      "default": 0
    },
    disabled: {
      type: Boolean,
      "default": false
    }
  },
  style: PickListStyle,
  provide: function provide() {
    return {
      $pcPickList: this,
      $parentInstance: this
    };
  }
};

function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var script = {
  name: 'PickList',
  "extends": script$1,
  inheritAttrs: false,
  emits: ['update:modelValue', 'reorder', 'update:selection', 'selection-change', 'move-to-target', 'move-to-source', 'move-all-to-target', 'move-all-to-source', 'focus', 'blur'],
  itemTouched: false,
  reorderDirection: null,
  styleElement: null,
  media: null,
  mediaChangeListener: null,
  data: function data() {
    return {
      d_selection: this.selection,
      viewChanged: false
    };
  },
  watch: {
    selection: function selection(newValue) {
      this.d_selection = newValue;
    },
    breakpoint: function breakpoint() {
      this.destroyMedia();
      this.initMedia();
    }
  },
  updated: function updated() {
    if (this.reorderDirection) {
      this.updateListScroll(this.$refs.sourceList.$el);
      this.updateListScroll(this.$refs.targetList.$el);
      this.reorderDirection = null;
    }
  },
  beforeUnmount: function beforeUnmount() {
    this.destroyStyle();
    this.destroyMedia();
  },
  mounted: function mounted() {
    if (this.responsive) {
      this.createStyle();
      this.initMedia();
    }
  },
  methods: {
    updateSelection: function updateSelection(event) {
      this.$emit('update:selection', this.d_selection);
      this.$emit('selection-change', {
        originalEvent: event,
        value: this.d_selection
      });
    },
    onChangeSelection: function onChangeSelection(params, listIndex) {
      this.d_selection[listIndex] = params.value;
      this.updateSelection(params.event);
    },
    onListFocus: function onListFocus(event, listType) {
      this.$emit('focus', event, listType);
    },
    onListBlur: function onListBlur(event, listType) {
      this.$emit('blur', event, listType);
    },
    onReorderUpdate: function onReorderUpdate(event, value, listIndex) {
      this.$emit('update:modelValue', value);
      this.$emit('reorder', {
        originalEvent: event,
        value: value,
        direction: this.reorderDirection,
        listIndex: listIndex
      });
    },
    onItemDblClick: function onItemDblClick(event, listIndex) {
      if (listIndex === 0) this.moveToTarget({
        event: event.originalEvent
      });else if (listIndex === 1) this.moveToSource({
        event: event.originalEvent
      });
    },
    moveUp: function moveUp(event, listIndex) {
      if (this.d_selection && this.d_selection[listIndex]) {
        var valueList = _toConsumableArray(this.modelValue[listIndex]);
        var selectionList = this.d_selection[listIndex];
        var selectedIndices = selectionList.map(function (item) {
          return findIndexInList(item, valueList);
        }).sort(function (a, b) {
          return a - b;
        });
        for (var i = 0; i < selectedIndices.length; i++) {
          var selectedItemIndex = selectedIndices[i];
          if (selectedItemIndex !== 0) {
            var movedItem = valueList[selectedItemIndex];
            var temp = valueList[selectedItemIndex - 1];
            valueList[selectedItemIndex - 1] = movedItem;
            valueList[selectedItemIndex] = temp;
          } else {
            break;
          }
        }
        var value = _toConsumableArray(this.modelValue);
        value[listIndex] = valueList;
        this.reorderDirection = 'up';
        this.onReorderUpdate(event, value, listIndex);
      }
    },
    moveTop: function moveTop(event, listIndex) {
      if (this.d_selection) {
        var valueList = _toConsumableArray(this.modelValue[listIndex]);
        var selectionList = this.d_selection[listIndex];
        for (var i = 0; i < selectionList.length; i++) {
          var selectedItem = selectionList[i];
          var selectedItemIndex = findIndexInList(selectedItem, valueList);
          if (selectedItemIndex !== 0) {
            var movedItem = valueList.splice(selectedItemIndex, 1)[0];
            valueList.unshift(movedItem);
          } else {
            break;
          }
        }
        var value = _toConsumableArray(this.modelValue);
        value[listIndex] = valueList;
        this.reorderDirection = 'top';
        this.onReorderUpdate(event, value, listIndex);
      }
    },
    moveDown: function moveDown(event, listIndex) {
      if (this.d_selection && this.d_selection[listIndex]) {
        var valueList = _toConsumableArray(this.modelValue[listIndex]);
        var selectionList = this.d_selection[listIndex];
        var selectedIndices = selectionList.map(function (item) {
          return findIndexInList(item, valueList);
        }).sort(function (a, b) {
          return b - a;
        });
        for (var i = 0; i < selectedIndices.length; i++) {
          var selectedItemIndex = selectedIndices[i];
          if (selectedItemIndex !== valueList.length - 1) {
            var movedItem = valueList[selectedItemIndex];
            var temp = valueList[selectedItemIndex + 1];
            valueList[selectedItemIndex + 1] = movedItem;
            valueList[selectedItemIndex] = temp;
          } else {
            break;
          }
        }
        var value = _toConsumableArray(this.modelValue);
        value[listIndex] = valueList;
        this.reorderDirection = 'down';
        this.onReorderUpdate(event, value, listIndex);
      }
    },
    moveBottom: function moveBottom(event, listIndex) {
      if (this.d_selection) {
        var valueList = _toConsumableArray(this.modelValue[listIndex]);
        var selectionList = this.d_selection[listIndex];
        for (var i = selectionList.length - 1; i >= 0; i--) {
          var selectedItem = selectionList[i];
          var selectedItemIndex = findIndexInList(selectedItem, valueList);
          if (selectedItemIndex !== valueList.length - 1) {
            var movedItem = valueList.splice(selectedItemIndex, 1)[0];
            valueList.push(movedItem);
          } else {
            break;
          }
        }
        var value = _toConsumableArray(this.modelValue);
        value[listIndex] = valueList;
        this.reorderDirection = 'bottom';
        this.onReorderUpdate(event, value, listIndex);
      }
    },
    moveToTarget: function moveToTarget(event) {
      var selection = this.d_selection && this.d_selection[0] ? this.d_selection[0] : null;
      var sourceList = _toConsumableArray(this.modelValue[0]);
      var targetList = _toConsumableArray(this.modelValue[1]);
      if (selection) {
        for (var i = 0; i < selection.length; i++) {
          var selectedItem = selection[i];
          if (findIndexInList(selectedItem, targetList) == -1) {
            targetList.push(sourceList.splice(findIndexInList(selectedItem, sourceList), 1)[0]);
          }
        }
        var value = _toConsumableArray(this.modelValue);
        value[0] = sourceList;
        value[1] = targetList;
        this.$emit('update:modelValue', value);
        this.$emit('move-to-target', {
          originalEvent: event,
          items: _toConsumableArray(new Set(selection))
        });
        this.d_selection[0] = [];
        this.updateSelection(event);
      }
    },
    moveAllToTarget: function moveAllToTarget(event) {
      if (this.modelValue[0]) {
        var sourceList = _toConsumableArray(this.modelValue[0]);
        var targetList = _toConsumableArray(this.modelValue[1]);
        this.$emit('move-all-to-target', {
          originalEvent: event,
          items: sourceList
        });
        targetList = [].concat(_toConsumableArray(targetList), _toConsumableArray(sourceList));
        sourceList = [];
        var value = _toConsumableArray(this.modelValue);
        value[0] = sourceList;
        value[1] = targetList;
        this.$emit('update:modelValue', value);
        this.d_selection = [[], []];
        this.updateSelection(event);
      }
    },
    moveToSource: function moveToSource(event) {
      var selection = this.d_selection && this.d_selection[1] ? this.d_selection[1] : null;
      var sourceList = _toConsumableArray(this.modelValue[0]);
      var targetList = _toConsumableArray(this.modelValue[1]);
      if (selection) {
        for (var i = 0; i < selection.length; i++) {
          var selectedItem = selection[i];
          if (findIndexInList(selectedItem, sourceList) == -1) {
            sourceList.push(targetList.splice(findIndexInList(selectedItem, targetList), 1)[0]);
          }
        }
        var value = _toConsumableArray(this.modelValue);
        value[0] = sourceList;
        value[1] = targetList;
        this.$emit('update:modelValue', value);
        this.$emit('move-to-source', {
          originalEvent: event,
          items: _toConsumableArray(new Set(selection))
        });
        this.d_selection[1] = [];
        this.updateSelection(event);
      }
    },
    moveAllToSource: function moveAllToSource(event) {
      if (this.modelValue[1]) {
        var sourceList = _toConsumableArray(this.modelValue[0]);
        var targetList = _toConsumableArray(this.modelValue[1]);
        this.$emit('move-all-to-source', {
          originalEvent: event,
          items: targetList
        });
        sourceList = [].concat(_toConsumableArray(sourceList), _toConsumableArray(targetList));
        targetList = [];
        var value = _toConsumableArray(this.modelValue);
        value[0] = sourceList;
        value[1] = targetList;
        this.$emit('update:modelValue', value);
        this.d_selection = [[], []];
        this.updateSelection(event);
      }
    },
    onItemClick: function onItemClick(event, item, index, listIndex) {
      var listType = listIndex === 0 ? 'sourceList' : 'targetList';
      this.itemTouched = false;
      var selectionList = this.d_selection[listIndex];
      var selectedIndex = findIndexInList(item, selectionList);
      var selected = selectedIndex != -1;
      var metaSelection = this.itemTouched ? false : this.metaKeySelection;
      var selectedId = find(this.$refs[listType].$el, '[data-pc-section="item"]')[index].getAttribute('id');
      this.focusedOptionIndex = selectedId;
      var _selection;
      if (metaSelection) {
        var metaKey = event.metaKey || event.ctrlKey;
        if (selected && metaKey) {
          _selection = selectionList.filter(function (val, index) {
            return index !== selectedIndex;
          });
        } else {
          _selection = metaKey ? selectionList ? _toConsumableArray(selectionList) : [] : [];
          _selection.push(item);
        }
      } else {
        if (selected) {
          _selection = selectionList.filter(function (val, index) {
            return index !== selectedIndex;
          });
        } else {
          _selection = selectionList ? _toConsumableArray(selectionList) : [];
          _selection.push(item);
        }
      }
      var newSelection = _toConsumableArray(this.d_selection);
      newSelection[listIndex] = _selection;
      this.d_selection = newSelection;
      this.updateSelection(event);
    },
    updateListScroll: function updateListScroll(listElement) {
      var listItems = find(listElement, '[data-pc-section="item"][data-p-selected="true"]');
      if (listItems && listItems.length) {
        switch (this.reorderDirection) {
          case 'up':
            scrollInView(listElement, listItems[0]);
            break;
          case 'top':
            listElement.scrollTop = 0;
            break;
          case 'down':
            scrollInView(listElement, listItems[listItems.length - 1]);
            break;
          case 'bottom':
            listElement.scrollTop = listElement.scrollHeight;
            break;
        }
      }
    },
    initMedia: function initMedia() {
      this.media = window.matchMedia("(max-width: ".concat(this.breakpoint, ")"));
      this.viewChanged = this.media.matches;
      this.bindMediaChangeListener();
    },
    destroyMedia: function destroyMedia() {
      this.unbindMediaChangeListener();
    },
    bindMediaChangeListener: function bindMediaChangeListener() {
      var _this = this;
      if (this.media && !this.mediaChangeListener) {
        this.mediaChangeListener = function (event) {
          _this.viewChanged = event.matches;
        };
        this.media.addEventListener('change', this.mediaChangeListener);
      }
    },
    unbindMediaChangeListener: function unbindMediaChangeListener() {
      if (this.media && this.mediaChangeListener) {
        this.media.removeEventListener('change', this.mediaChangeListener);
        this.mediaChangeListener = null;
      }
    },
    createStyle: function createStyle() {
      if (!this.styleElement && !this.isUnstyled) {
        var _this$$primevue;
        this.styleElement = document.createElement('style');
        this.styleElement.type = 'text/css';
        setAttribute(this.styleElement, 'nonce', (_this$$primevue = this.$primevue) === null || _this$$primevue === void 0 || (_this$$primevue = _this$$primevue.config) === null || _this$$primevue === void 0 || (_this$$primevue = _this$$primevue.csp) === null || _this$$primevue === void 0 ? void 0 : _this$$primevue.nonce);
        document.head.appendChild(this.styleElement);
        var innerHTML = "\n@media screen and (max-width: ".concat(this.breakpoint, ") {\n    .p-picklist[").concat(this.$attrSelector, "] {\n        flex-direction: column;\n    }\n\n    .p-picklist[").concat(this.$attrSelector, "] .p-picklist-controls {\n        flex-direction: row;\n    }\n}\n");
        this.styleElement.innerHTML = innerHTML;
      }
    },
    destroyStyle: function destroyStyle() {
      if (this.styleElement) {
        document.head.removeChild(this.styleElement);
        this.styleElement = null;
      }
    },
    moveDisabled: function moveDisabled(index) {
      return this.disabled ? true : this.d_selection && (!this.d_selection[index] || !this.d_selection[index].length) ? true : false;
    },
    moveAllDisabled: function moveAllDisabled(list) {
      return this.disabled ? true : isEmpty(this[list]);
    }
  },
  computed: {
    idSource: function idSource() {
      return "".concat(this.$id, "_source");
    },
    idTarget: function idTarget() {
      return "".concat(this.$id, "_target");
    },
    sourceList: function sourceList() {
      return this.modelValue && this.modelValue[0] ? this.modelValue[0] : null;
    },
    targetList: function targetList() {
      return this.modelValue && this.modelValue[1] ? this.modelValue[1] : null;
    },
    moveUpAriaLabel: function moveUpAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveUp : undefined;
    },
    moveTopAriaLabel: function moveTopAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveTop : undefined;
    },
    moveDownAriaLabel: function moveDownAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveDown : undefined;
    },
    moveBottomAriaLabel: function moveBottomAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveBottom : undefined;
    },
    moveToTargetAriaLabel: function moveToTargetAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveToTarget : undefined;
    },
    moveAllToTargetAriaLabel: function moveAllToTargetAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveAllToTarget : undefined;
    },
    moveToSourceAriaLabel: function moveToSourceAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveToSource : undefined;
    },
    moveAllToSourceAriaLabel: function moveAllToSourceAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.moveAllToSource : undefined;
    }
  },
  components: {
    Listbox: Listbox,
    Button: Button,
    AngleRightIcon: AngleRightIcon,
    AngleLeftIcon: AngleLeftIcon,
    AngleDownIcon: AngleDownIcon,
    AngleUpIcon: AngleUpIcon,
    AngleDoubleRightIcon: AngleDoubleRightIcon,
    AngleDoubleLeftIcon: AngleDoubleLeftIcon,
    AngleDoubleDownIcon: AngleDoubleDownIcon,
    AngleDoubleUpIcon: AngleDoubleUpIcon
  },
  directives: {
    ripple: Ripple
  }
};

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), true).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: true, configurable: true, writable: true }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_AngleUpIcon = resolveComponent("AngleUpIcon");
  var _component_Button = resolveComponent("Button");
  var _component_AngleDoubleUpIcon = resolveComponent("AngleDoubleUpIcon");
  var _component_AngleDownIcon = resolveComponent("AngleDownIcon");
  var _component_AngleDoubleDownIcon = resolveComponent("AngleDoubleDownIcon");
  var _component_Listbox = resolveComponent("Listbox");
  return openBlock(), createElementBlock("div", mergeProps({
    "class": _ctx.cx('root')
  }, _ctx.ptmi('root')), [_ctx.showSourceControls ? (openBlock(), createElementBlock("div", mergeProps({
    key: 0,
    "class": _ctx.cx('sourceControls')
  }, _ctx.ptm('sourceControls'), {
    "data-pc-group-section": "controls"
  }), [renderSlot(_ctx.$slots, "sourcecontrolsstart"), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveUpAriaLabel,
    disabled: $options.moveDisabled(0),
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $options.moveUp($event, 0);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveUpButtonProps), {
    pt: _ctx.ptm('pcSourceMoveUpButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "moveupicon", {}, function () {
        return [createVNode(_component_AngleUpIcon, mergeProps(_ctx.ptm('pcSourceMoveUpButton')['icon'], {
          "data-pc-section": "moveupicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveTopAriaLabel,
    disabled: $options.moveDisabled(0),
    onClick: _cache[1] || (_cache[1] = function ($event) {
      return $options.moveTop($event, 0);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveTopButtonProps), {
    pt: _ctx.ptm('pcSourceMoveTopButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movetopicon", {}, function () {
        return [createVNode(_component_AngleDoubleUpIcon, mergeProps(_ctx.ptm('pcSourceMoveTopButton')['icon'], {
          "data-pc-section": "movetopicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveDownAriaLabel,
    disabled: $options.moveDisabled(0),
    onClick: _cache[2] || (_cache[2] = function ($event) {
      return $options.moveDown($event, 0);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveDownButtonProps), {
    pt: _ctx.ptm('pcSourceMoveDownButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movedownicon", {}, function () {
        return [createVNode(_component_AngleDownIcon, mergeProps(_ctx.ptm('pcSourceMoveDownButton')['icon'], {
          "data-pc-section": "movedownicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveBottomAriaLabel,
    disabled: $options.moveDisabled(0),
    onClick: _cache[3] || (_cache[3] = function ($event) {
      return $options.moveBottom($event, 0);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveBottomButtonProps), {
    pt: _ctx.ptm('pcSourceMoveBottomButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movebottomicon", {}, function () {
        return [createVNode(_component_AngleDoubleDownIcon, mergeProps(_ctx.ptm('pcSourceMoveBottomButton')['icon'], {
          "data-pc-section": "movebottomicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), renderSlot(_ctx.$slots, "sourcecontrolsend")], 16)) : createCommentVNode("", true), createElementVNode("div", mergeProps({
    "class": _ctx.cx('sourceListContainer')
  }, _ctx.ptm('sourceListContainer'), {
    "data-pc-group-section": "listcontainer"
  }), [createVNode(_component_Listbox, {
    ref: "sourceList",
    id: $options.idSource + '_list',
    modelValue: $data.d_selection[0],
    options: $options.sourceList,
    multiple: "",
    metaKeySelection: _ctx.metaKeySelection,
    listStyle: _ctx.listStyle,
    scrollHeight: _ctx.scrollHeight,
    tabindex: $options.sourceList && $options.sourceList.length > 0 ? _ctx.tabindex : -1,
    dataKey: _ctx.dataKey,
    autoOptionFocus: _ctx.autoOptionFocus,
    focusOnHover: _ctx.focusOnHover,
    striped: _ctx.striped,
    disabled: _ctx.disabled,
    pt: _ctx.ptm('pcListbox'),
    unstyled: _ctx.unstyled,
    onFocus: _cache[4] || (_cache[4] = function ($event) {
      return $options.onListFocus($event, 'sourceList');
    }),
    onBlur: _cache[5] || (_cache[5] = function ($event) {
      return $options.onListBlur($event, 'sourceList');
    }),
    onChange: _cache[6] || (_cache[6] = function ($event) {
      return $options.onChangeSelection($event, 0);
    }),
    onItemDblclick: _cache[7] || (_cache[7] = function ($event) {
      return $options.onItemDblClick($event, 0);
    }),
    "data-pc-group-section": "list"
  }, createSlots({
    option: withCtx(function (_ref) {
      var option = _ref.option,
        selected = _ref.selected,
        index = _ref.index;
      return [renderSlot(_ctx.$slots, _ctx.$slots.option ? 'option' : 'item', {
        item: option,
        option: option,
        selected: selected,
        index: index
      })];
    }),
    _: 2
  }, [_ctx.$slots.sourceheader ? {
    name: "header",
    fn: withCtx(function () {
      return [renderSlot(_ctx.$slots, "sourceheader")];
    }),
    key: "0"
  } : undefined]), 1032, ["id", "modelValue", "options", "metaKeySelection", "listStyle", "scrollHeight", "tabindex", "dataKey", "autoOptionFocus", "focusOnHover", "striped", "disabled", "pt", "unstyled"])], 16), createElementVNode("div", mergeProps({
    "class": _ctx.cx('transferControls')
  }, _ctx.ptm('transferControls'), {
    "data-pc-group-section": "controls"
  }), [renderSlot(_ctx.$slots, "movecontrolsstart"), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveToTargetAriaLabel,
    onClick: $options.moveToTarget,
    disabled: $options.moveDisabled(0)
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveToTargetProps), {
    pt: _ctx.ptm('pcMoveToTargetButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movetotargeticon", {
        viewChanged: $data.viewChanged
      }, function () {
        return [(openBlock(), createBlock(resolveDynamicComponent($data.viewChanged ? 'AngleDownIcon' : 'AngleRightIcon'), mergeProps(_ctx.ptm('pcMoveToTargetButton')['icon'], {
          "data-pc-section": "movetotargeticon"
        }), null, 16))];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "onClick", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveAllToTargetAriaLabel,
    onClick: $options.moveAllToTarget,
    disabled: $options.moveAllDisabled('sourceList')
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveAllToTargetProps), {
    pt: _ctx.ptm('pcMoveAllToTargetButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movealltotargeticon", {
        viewChanged: $data.viewChanged
      }, function () {
        return [(openBlock(), createBlock(resolveDynamicComponent($data.viewChanged ? 'AngleDoubleDownIcon' : 'AngleDoubleRightIcon'), mergeProps(_ctx.ptm('pcMoveAllToTargetButton')['icon'], {
          "data-pc-section": "movealltotargeticon"
        }), null, 16))];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "onClick", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveToSourceAriaLabel,
    onClick: $options.moveToSource,
    disabled: $options.moveDisabled(1)
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveToSourceProps), {
    pt: _ctx.ptm('pcMoveToSourceButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movetosourceicon", {
        viewChanged: $data.viewChanged
      }, function () {
        return [(openBlock(), createBlock(resolveDynamicComponent($data.viewChanged ? 'AngleUpIcon' : 'AngleLeftIcon'), mergeProps(_ctx.ptm('pcMoveToSourceButton')['icon'], {
          "data-pc-section": "movetosourceicon"
        }), null, 16))];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "onClick", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveAllToSourceAriaLabel,
    onClick: $options.moveAllToSource,
    disabled: $options.moveAllDisabled('targetList')
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveAllToSourceProps), {
    pt: _ctx.ptm('pcMoveAllToSourceButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movealltosourceicon", {
        viewChanged: $data.viewChanged
      }, function () {
        return [(openBlock(), createBlock(resolveDynamicComponent($data.viewChanged ? 'AngleDoubleUpIcon' : 'AngleDoubleLeftIcon'), mergeProps(_ctx.ptm('pcMoveAllToSourceButton')['icon'], {
          "data-pc-section": "movealltosourceicon"
        }), null, 16))];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "onClick", "disabled", "pt", "unstyled"]), renderSlot(_ctx.$slots, "movecontrolsend")], 16), createElementVNode("div", mergeProps({
    "class": _ctx.cx('targetListContainer')
  }, _ctx.ptm('targetListContainer'), {
    "data-pc-group-section": "listcontainer"
  }), [createVNode(_component_Listbox, {
    ref: "targetList",
    id: $options.idTarget + '_list',
    modelValue: $data.d_selection[1],
    options: $options.targetList,
    multiple: "",
    metaKeySelection: _ctx.metaKeySelection,
    listStyle: _ctx.listStyle,
    scrollHeight: _ctx.scrollHeight,
    tabindex: $options.targetList && $options.targetList.length > 0 ? _ctx.tabindex : -1,
    dataKey: _ctx.dataKey,
    autoOptionFocus: _ctx.autoOptionFocus,
    focusOnHover: _ctx.focusOnHover,
    striped: _ctx.striped,
    disabled: _ctx.disabled,
    pt: _ctx.ptm('pcListbox'),
    unstyled: _ctx.unstyled,
    onFocus: _cache[8] || (_cache[8] = function ($event) {
      return $options.onListFocus($event, 'targetList');
    }),
    onBlur: _cache[9] || (_cache[9] = function ($event) {
      return $options.onListBlur($event, 'targetList');
    }),
    onChange: _cache[10] || (_cache[10] = function ($event) {
      return $options.onChangeSelection($event, 1);
    }),
    onItemDblclick: _cache[11] || (_cache[11] = function ($event) {
      return $options.onItemDblClick($event, 1);
    }),
    "data-pc-group-section": "list"
  }, createSlots({
    option: withCtx(function (_ref2) {
      var option = _ref2.option,
        selected = _ref2.selected,
        index = _ref2.index;
      return [renderSlot(_ctx.$slots, _ctx.$slots.option ? 'option' : 'item', {
        item: option,
        option: option,
        selected: selected,
        index: index
      })];
    }),
    _: 2
  }, [_ctx.$slots.targetheader ? {
    name: "header",
    fn: withCtx(function () {
      return [renderSlot(_ctx.$slots, "targetheader")];
    }),
    key: "0"
  } : undefined]), 1032, ["id", "modelValue", "options", "metaKeySelection", "listStyle", "scrollHeight", "tabindex", "dataKey", "autoOptionFocus", "focusOnHover", "striped", "disabled", "pt", "unstyled"])], 16), _ctx.showTargetControls ? (openBlock(), createElementBlock("div", mergeProps({
    key: 1,
    "class": _ctx.cx('targetControls')
  }, _ctx.ptm('targetControls'), {
    "data-pc-group-section": "controls"
  }), [renderSlot(_ctx.$slots, "targetcontrolsstart"), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveUpAriaLabel,
    disabled: $options.moveDisabled(1),
    onClick: _cache[12] || (_cache[12] = function ($event) {
      return $options.moveUp($event, 1);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveUpButtonProps), {
    pt: _ctx.ptm('pcTargetMoveUpButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "moveupicon", {}, function () {
        return [createVNode(_component_AngleUpIcon, mergeProps(_ctx.ptm('pcTargetMoveUpButton')['icon'], {
          "data-pc-section": "moveupicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveTopAriaLabel,
    disabled: $options.moveDisabled(1),
    onClick: _cache[13] || (_cache[13] = function ($event) {
      return $options.moveTop($event, 1);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveTopButtonProps), {
    pt: _ctx.ptm('pcTargetMoveTopButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movetopicon", {}, function () {
        return [createVNode(_component_AngleDoubleUpIcon, mergeProps(_ctx.ptm('pcTargetMoveTopButton')['icon'], {
          "data-pc-section": "movetopicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveDownAriaLabel,
    disabled: $options.moveDisabled(1),
    onClick: _cache[14] || (_cache[14] = function ($event) {
      return $options.moveDown($event, 1);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveDownButtonProps), {
    pt: _ctx.ptm('pcTargetMoveDownButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movedownicon", {}, function () {
        return [createVNode(_component_AngleDownIcon, mergeProps(_ctx.ptm('pcTargetMoveDownButton')['icon'], {
          "data-pc-section": "movedownicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), createVNode(_component_Button, mergeProps({
    "aria-label": $options.moveBottomAriaLabel,
    disabled: $options.moveDisabled(1),
    onClick: _cache[15] || (_cache[15] = function ($event) {
      return $options.moveBottom($event, 1);
    })
  }, _objectSpread(_objectSpread({}, _ctx.buttonProps), _ctx.moveBottomButtonProps), {
    pt: _ctx.ptm('pcTargetMoveBottomButton'),
    unstyled: _ctx.unstyled
  }), {
    icon: withCtx(function () {
      return [renderSlot(_ctx.$slots, "movebottomicon", {}, function () {
        return [createVNode(_component_AngleDoubleDownIcon, mergeProps(_ctx.ptm('pcTargetMoveBottomButton')['icon'], {
          "data-pc-section": "movebottomicon"
        }), null, 16)];
      })];
    }),
    _: 3
  }, 16, ["aria-label", "disabled", "pt", "unstyled"]), renderSlot(_ctx.$slots, "targetcontrolsend")], 16)) : createCommentVNode("", true)], 16);
}

script.render = render;

export { script as default };
//# sourceMappingURL=index.mjs.map
