<?php

namespace Laravel\Nightwatch\Hooks;

use GuzzleHttp\Promise\PromiseInterface;
use Laravel\Nightwatch\Core;
use Laravel\Nightwatch\State\CommandState;
use Laravel\Nightwatch\State\RequestState;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Throwable;

/**
 * @internal
 */
final class GuzzleMiddleware
{
    /**
     * @param  Core<RequestState|CommandState>  $nightwatch
     */
    public function __construct(
        private Core $nightwatch,
    ) {
        //
    }

    /**
     * TODO record the failed responses as well.
     */
    public function __invoke(callable $handler): callable
    {
        if (! $this->nightwatch->potentiallySampling()) {
            return $handler;
        }

        if ($this->nightwatch->config['filtering']['ignore_outgoing_requests']) {
            return $handler;
        }

        return function (RequestInterface $request, array $options) use ($handler): PromiseInterface {
            try {
                $startMicrotime = $this->nightwatch->clock->microtime();
            } catch (Throwable $e) {
                $this->nightwatch->report($e, handled: true);

                return $handler($request, $options);
            }

            return $handler($request, $options)->then(function (ResponseInterface $response) use ($request, $startMicrotime): ResponseInterface {
                try {
                    $endMicrotime = $this->nightwatch->clock->microtime();

                    $this->nightwatch->outgoingRequest(
                        $startMicrotime, $endMicrotime,
                        $request, $response,
                    );
                } catch (Throwable $e) {
                    $this->nightwatch->report($e, handled: true);
                }

                return $response;
            });
        };
    }
}
