import {
  __require
} from "./chunk-2TUXWMP5.js";

// node_modules/uuid/dist/esm-browser/rng.js
var getRandomValues;
var rnds8 = new Uint8Array(16);
function rng() {
  if (!getRandomValues) {
    getRandomValues = typeof crypto !== "undefined" && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);
    if (!getRandomValues) {
      throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");
    }
  }
  return getRandomValues(rnds8);
}

// node_modules/uuid/dist/esm-browser/regex.js
var regex_default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

// node_modules/uuid/dist/esm-browser/validate.js
function validate(uuid) {
  return typeof uuid === "string" && regex_default.test(uuid);
}
var validate_default = validate;

// node_modules/uuid/dist/esm-browser/stringify.js
var byteToHex = [];
for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 256).toString(16).slice(1));
}
function unsafeStringify(arr, offset = 0) {
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + "-" + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + "-" + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + "-" + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + "-" + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}

// node_modules/uuid/dist/esm-browser/parse.js
function parse(uuid) {
  if (!validate_default(uuid)) {
    throw TypeError("Invalid UUID");
  }
  let v;
  const arr = new Uint8Array(16);
  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 255;
  arr[2] = v >>> 8 & 255;
  arr[3] = v & 255;
  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 255;
  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 255;
  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 255;
  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 1099511627776 & 255;
  arr[11] = v / 4294967296 & 255;
  arr[12] = v >>> 24 & 255;
  arr[13] = v >>> 16 & 255;
  arr[14] = v >>> 8 & 255;
  arr[15] = v & 255;
  return arr;
}
var parse_default = parse;

// node_modules/uuid/dist/esm-browser/v35.js
function stringToBytes(str) {
  str = unescape(encodeURIComponent(str));
  const bytes = [];
  for (let i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }
  return bytes;
}
var DNS = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
var URL = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
function v35(name, version, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    var _namespace;
    if (typeof value === "string") {
      value = stringToBytes(value);
    }
    if (typeof namespace === "string") {
      namespace = parse_default(namespace);
    }
    if (((_namespace = namespace) === null || _namespace === void 0 ? void 0 : _namespace.length) !== 16) {
      throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");
    }
    let bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 15 | version;
    bytes[8] = bytes[8] & 63 | 128;
    if (buf) {
      offset = offset || 0;
      for (let i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }
      return buf;
    }
    return unsafeStringify(bytes);
  }
  try {
    generateUUID.name = name;
  } catch (err) {
  }
  generateUUID.DNS = DNS;
  generateUUID.URL = URL;
  return generateUUID;
}

// node_modules/uuid/dist/esm-browser/md5.js
function md5(bytes) {
  if (typeof bytes === "string") {
    const msg = unescape(encodeURIComponent(bytes));
    bytes = new Uint8Array(msg.length);
    for (let i = 0; i < msg.length; ++i) {
      bytes[i] = msg.charCodeAt(i);
    }
  }
  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
}
function md5ToHexEncodedArray(input) {
  const output = [];
  const length32 = input.length * 32;
  const hexTab = "0123456789abcdef";
  for (let i = 0; i < length32; i += 8) {
    const x = input[i >> 5] >>> i % 32 & 255;
    const hex = parseInt(hexTab.charAt(x >>> 4 & 15) + hexTab.charAt(x & 15), 16);
    output.push(hex);
  }
  return output;
}
function getOutputLength(inputLength8) {
  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;
}
function wordsToMd5(x, len) {
  x[len >> 5] |= 128 << len % 32;
  x[getOutputLength(len) - 1] = len;
  let a = 1732584193;
  let b = -271733879;
  let c = -1732584194;
  let d = 271733878;
  for (let i = 0; i < x.length; i += 16) {
    const olda = a;
    const oldb = b;
    const oldc = c;
    const oldd = d;
    a = md5ff(a, b, c, d, x[i], 7, -680876936);
    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
    b = md5gg(b, c, d, a, x[i], 20, -373897302);
    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
    d = md5hh(d, a, b, c, x[i], 11, -358537222);
    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
    a = md5ii(a, b, c, d, x[i], 6, -198630844);
    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
    a = safeAdd(a, olda);
    b = safeAdd(b, oldb);
    c = safeAdd(c, oldc);
    d = safeAdd(d, oldd);
  }
  return [a, b, c, d];
}
function bytesToWords(input) {
  if (input.length === 0) {
    return [];
  }
  const length8 = input.length * 8;
  const output = new Uint32Array(getOutputLength(length8));
  for (let i = 0; i < length8; i += 8) {
    output[i >> 5] |= (input[i / 8] & 255) << i % 32;
  }
  return output;
}
function safeAdd(x, y) {
  const lsw = (x & 65535) + (y & 65535);
  const msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return msw << 16 | lsw & 65535;
}
function bitRotateLeft(num, cnt) {
  return num << cnt | num >>> 32 - cnt;
}
function md5cmn(q, a, b, x, s, t) {
  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
}
function md5ff(a, b, c, d, x, s, t) {
  return md5cmn(b & c | ~b & d, a, b, x, s, t);
}
function md5gg(a, b, c, d, x, s, t) {
  return md5cmn(b & d | c & ~d, a, b, x, s, t);
}
function md5hh(a, b, c, d, x, s, t) {
  return md5cmn(b ^ c ^ d, a, b, x, s, t);
}
function md5ii(a, b, c, d, x, s, t) {
  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
}
var md5_default = md5;

// node_modules/uuid/dist/esm-browser/v3.js
var v3 = v35("v3", 48, md5_default);

// node_modules/uuid/dist/esm-browser/native.js
var randomUUID = typeof crypto !== "undefined" && crypto.randomUUID && crypto.randomUUID.bind(crypto);
var native_default = {
  randomUUID
};

// node_modules/uuid/dist/esm-browser/v4.js
function v4(options, buf, offset) {
  if (native_default.randomUUID && !buf && !options) {
    return native_default.randomUUID();
  }
  options = options || {};
  const rnds = options.random || (options.rng || rng)();
  rnds[6] = rnds[6] & 15 | 64;
  rnds[8] = rnds[8] & 63 | 128;
  if (buf) {
    offset = offset || 0;
    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }
    return buf;
  }
  return unsafeStringify(rnds);
}
var v4_default = v4;

// node_modules/uuid/dist/esm-browser/sha1.js
function f(s, x, y, z) {
  switch (s) {
    case 0:
      return x & y ^ ~x & z;
    case 1:
      return x ^ y ^ z;
    case 2:
      return x & y ^ x & z ^ y & z;
    case 3:
      return x ^ y ^ z;
  }
}
function ROTL(x, n) {
  return x << n | x >>> 32 - n;
}
function sha1(bytes) {
  const K = [1518500249, 1859775393, 2400959708, 3395469782];
  const H = [1732584193, 4023233417, 2562383102, 271733878, 3285377520];
  if (typeof bytes === "string") {
    const msg = unescape(encodeURIComponent(bytes));
    bytes = [];
    for (let i = 0; i < msg.length; ++i) {
      bytes.push(msg.charCodeAt(i));
    }
  } else if (!Array.isArray(bytes)) {
    bytes = Array.prototype.slice.call(bytes);
  }
  bytes.push(128);
  const l = bytes.length / 4 + 2;
  const N = Math.ceil(l / 16);
  const M = new Array(N);
  for (let i = 0; i < N; ++i) {
    const arr = new Uint32Array(16);
    for (let j = 0; j < 16; ++j) {
      arr[j] = bytes[i * 64 + j * 4] << 24 | bytes[i * 64 + j * 4 + 1] << 16 | bytes[i * 64 + j * 4 + 2] << 8 | bytes[i * 64 + j * 4 + 3];
    }
    M[i] = arr;
  }
  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (bytes.length - 1) * 8 & 4294967295;
  for (let i = 0; i < N; ++i) {
    const W = new Uint32Array(80);
    for (let t = 0; t < 16; ++t) {
      W[t] = M[i][t];
    }
    for (let t = 16; t < 80; ++t) {
      W[t] = ROTL(W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16], 1);
    }
    let a = H[0];
    let b = H[1];
    let c = H[2];
    let d = H[3];
    let e = H[4];
    for (let t = 0; t < 80; ++t) {
      const s = Math.floor(t / 20);
      const T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[t] >>> 0;
      e = d;
      d = c;
      c = ROTL(b, 30) >>> 0;
      b = a;
      a = T;
    }
    H[0] = H[0] + a >>> 0;
    H[1] = H[1] + b >>> 0;
    H[2] = H[2] + c >>> 0;
    H[3] = H[3] + d >>> 0;
    H[4] = H[4] + e >>> 0;
  }
  return [H[0] >> 24 & 255, H[0] >> 16 & 255, H[0] >> 8 & 255, H[0] & 255, H[1] >> 24 & 255, H[1] >> 16 & 255, H[1] >> 8 & 255, H[1] & 255, H[2] >> 24 & 255, H[2] >> 16 & 255, H[2] >> 8 & 255, H[2] & 255, H[3] >> 24 & 255, H[3] >> 16 & 255, H[3] >> 8 & 255, H[3] & 255, H[4] >> 24 & 255, H[4] >> 16 & 255, H[4] >> 8 & 255, H[4] & 255];
}
var sha1_default = sha1;

// node_modules/uuid/dist/esm-browser/v5.js
var v5 = v35("v5", 80, sha1_default);

// node_modules/@giphy/js-util/dist/index.js
var LogLevel = ((LogLevel2) => {
  LogLevel2[LogLevel2["DEBUG"] = 0] = "DEBUG";
  LogLevel2[LogLevel2["INFO"] = 1] = "INFO";
  LogLevel2[LogLevel2["WARN"] = 2] = "WARN";
  LogLevel2[LogLevel2["ERROR"] = 3] = "ERROR";
  return LogLevel2;
})(LogLevel || {});
var Logger = {
  ENABLED: typeof window !== "undefined" && typeof location !== "undefined" && location.search.indexOf("giphy-debug") !== -1,
  LEVEL: 0,
  PREFIX: "GiphyJS",
  debug: (...msg) => {
    if (Logger.ENABLED && Logger.LEVEL <= 0) {
      console.debug(Logger.PREFIX, ...msg);
    }
  },
  info: (...msg) => {
    if (Logger.ENABLED && Logger.LEVEL <= 1) {
      console.info(Logger.PREFIX, ...msg);
    }
  },
  warn: (...msg) => {
    if (Logger.ENABLED && Logger.LEVEL <= 2) {
      console.warn(Logger.PREFIX, ...msg);
    }
  },
  error: (...msg) => {
    if (Logger.ENABLED && Logger.LEVEL <= 3) {
      console.error(Logger.PREFIX, ...msg);
    }
  }
};
var pingbackId = "";
var idLength = 16;
var noUUIDRandom = () => {
  let result = "";
  const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  const charactersLength = characters.length;
  for (let i = 0; i < idLength; i++) {
    result += characters.charAt(Math.floor(Math.random() * charactersLength));
  }
  return result;
};
var getPingbackId = () => {
  if (!pingbackId) {
    try {
      pingbackId = sessionStorage.getItem("giphyPingbackId");
    } catch (_) {
    }
    if (!pingbackId) {
      const hexTime = (/* @__PURE__ */ new Date()).getTime().toString(16);
      try {
        pingbackId = `${hexTime}${v4_default().replace(/-/g, "")}`.substring(0, idLength);
      } catch (error) {
        pingbackId = noUUIDRandom();
      }
      try {
        sessionStorage.setItem("giphyPingbackId", pingbackId);
      } catch (_) {
      }
    }
  }
  return pingbackId;
};
var get_pingback_id_default = getPingbackId;
var SUPPORTS_WEBP = null;
var checkIfWebP = new Promise((resolve) => {
  if (typeof Image === "undefined") {
    resolve(false);
  }
  const webp = new Image();
  webp.onload = () => {
    SUPPORTS_WEBP = true;
    resolve(SUPPORTS_WEBP);
  };
  webp.onerror = () => {
    SUPPORTS_WEBP = false;
    resolve(SUPPORTS_WEBP);
  };
  webp.src = "data:image/webp;base64,UklGRjoAAABXRUJQVlA4IC4AAACyAgCdASoCAAIALmk0mk0iIiIiIgBoSygABc6WWgAA/veff/0PP8bA//LwYAAA";
});
var gl = (typeof window !== "undefined" ? window : global) || {};
gl._GIPHY_SDK_HEADERS_ = gl._GIPHY_SDK_HEADERS_ || (gl.Headers ? new gl.Headers({
  "X-GIPHY-SDK-PLATFORM": "web"
}) : void 0);
var getGiphySDKRequestHeaders = () => gl._GIPHY_SDK_HEADERS_;
var appendGiphySDKRequestHeader = (key, value) => {
  var _a2;
  return (_a2 = getGiphySDKRequestHeaders()) == null ? void 0 : _a2.set(key, value);
};

// node_modules/@giphy/js-fetch-api/dist/index.js
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __require2 = ((x) => typeof __require !== "undefined" ? __require : typeof Proxy !== "undefined" ? new Proxy(x, {
  get: (a, b) => (typeof __require !== "undefined" ? __require : a)[b]
}) : x)(function(x) {
  if (typeof __require !== "undefined")
    return __require.apply(this, arguments);
  throw Error('Dynamic require of "' + x + '" is not supported');
});
var __commonJS = (cb, mod) => function __require22() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var require_package = __commonJS({
  "package.json"(exports, module) {
    module.exports = {
      scripts: {
        lint: "run -T eslint . --ext .ts,.tsx",
        clean: "rm -rf ./dist",
        dev: "parcel public/test.html",
        docs: "typedoc src/index.ts",
        build: "run -T tsup src/index.ts --format cjs,esm --dts && run -T publint",
        prepublish: "npm run clean && npm run build",
        test: "run -T jest --config ./jestconfig.js",
        "test:watch": "run -T jest --config ./jestconfig.js --watchAll"
      },
      name: "@giphy/js-fetch-api",
      version: "5.6.0",
      description: "Javascript API to fetch gifs and stickers from the GIPHY API.",
      homepage: "https://github.com/Giphy/giphy-js/tree/master/packages/fetch-api",
      main: "dist/index.cjs",
      types: "dist/index.d.ts",
      module: "dist/index.js",
      type: "module",
      sideEffects: false,
      exports: {
        ".": {
          types: "./dist/index.d.ts",
          import: "./dist/index.js",
          require: "./dist/index.cjs"
        },
        "./package.json": "./package.json"
      },
      files: [
        "dist/",
        "src/**/*"
      ],
      license: "MIT",
      publishConfig: {
        access: "public"
      },
      dependencies: {
        "@giphy/js-types": "*",
        "@giphy/js-util": "*"
      },
      devDependencies: {
        "jest-fetch-mock": "^3.0.3",
        "parcel-bundler": "latest",
        typedoc: "^0.20.37",
        "typedoc-thunder-theme": "^0.0.3",
        typescript: "^5.0.4"
      }
    };
  }
});
var BOOL_PROPS = [
  "is_anonymous",
  "is_community",
  "is_featured",
  "is_hidden",
  "is_indexable",
  "is_preserve_size",
  "is_realtime",
  "is_removed",
  "is_sticker",
  "is_dynamic"
  // not finalized, and not adding to Gif type until type RFC is finished
];
var USER_BOOL_PROPS = ["suppress_chrome", "is_public", "is_verified"];
var makeBool = (obj) => (prop) => obj[prop] = !!obj[prop];
var getTag = (tag) => typeof tag === "string" ? tag : tag.text;
var normalize = (gif, responseId = "") => {
  const newGif = __spreadValues({}, gif);
  newGif.id = String(newGif.id);
  newGif.tags = (newGif.tags || []).map(getTag);
  if (!newGif.bottle_data) {
    newGif.bottle_data = {};
  }
  newGif.response_id = responseId;
  BOOL_PROPS.forEach(makeBool(newGif));
  Object.keys(newGif.images || {}).forEach((name) => {
    const img = newGif.images[name];
    img.width = parseInt(img.width);
    img.height = parseInt(img.height);
  });
  const { user } = newGif;
  if (user) {
    const newUser = __spreadValues({}, user);
    USER_BOOL_PROPS.forEach(makeBool(newUser));
    newGif.user = newUser;
  }
  return newGif;
};
var normalizeGif = (result) => {
  const { response_id } = result.meta;
  result.data = normalize(result.data, response_id);
  return result;
};
var normalizeGifs = (result) => {
  const { response_id } = result.meta;
  result.data = result.data.map((gif) => normalize(gif, response_id));
  return result;
};
var gl2 = (typeof window !== "undefined" ? window : global) || {};
var serverUrl = gl2.GIPHY_API_URL || "https://api.giphy.com/v1/";
var setServerUrl = (url) => {
  serverUrl = url;
};
var FetchError = class extends Error {
  constructor(message, url, status = 0, statusText = "") {
    super(message);
    this.url = url;
    this.status = status;
    this.statusText = statusText;
  }
};
var GeoFetchError = class extends FetchError {
};
var fetch_error_default = FetchError;
var ERROR_PREFIX = `@giphy/js-fetch-api: `;
var DEFAULT_ERROR = "Error fetching";
var identity = (i) => i;
var requestMap = {};
var maxLife = 6e4;
var errorMaxLife = 6e3;
var purgeCache = () => {
  const now = Date.now();
  Object.keys(requestMap).forEach((key) => {
    const ttl = requestMap[key].isError ? errorMaxLife : maxLife;
    if (now - requestMap[key].ts >= ttl) {
      delete requestMap[key];
    }
  });
};
function request(url, options = {}) {
  const { apiVersion = 1, noCache = false, normalizer = identity } = options;
  const serverUrl_ = serverUrl.replace(/\/v\d+\/$/, `/v${apiVersion}/`);
  purgeCache();
  if (!requestMap[url] || noCache) {
    const fullUrl = `${serverUrl_}${url}`;
    const makeRequest = () => __async(this, null, function* () {
      var _a2, _b;
      let fetchError;
      try {
        const response = yield fetch(fullUrl, {
          method: "get"
        });
        if (response.ok) {
          const result = yield response.json();
          if (!((_a2 = result.meta) == null ? void 0 : _a2.response_id)) {
            throw { message: `synthetic response` };
          } else {
            return normalizer(result);
          }
        } else {
          let message = DEFAULT_ERROR;
          try {
            const result = yield response.json();
            if (result.message)
              message = result.message;
            if ((_b = result.meta) == null ? void 0 : _b.msg)
              message = result.meta.msg;
          } catch (_) {
          }
          if (requestMap[url]) {
            requestMap[url].isError = true;
          }
          let Cls = fetch_error_default;
          if (message === "This content is not available in your location") {
            Cls = GeoFetchError;
          }
          fetchError = new Cls(`${ERROR_PREFIX}${message}`, fullUrl, response.status, response.statusText);
        }
      } catch (unexpectedError) {
        fetchError = new fetch_error_default(unexpectedError.message, fullUrl);
        if (requestMap[url]) {
          requestMap[url].isError = true;
        }
      }
      throw fetchError;
    });
    requestMap[url] = { request: makeRequest(), ts: Date.now() };
  }
  return requestMap[url].request;
}
var request_default = request;
var getType = (options) => options && options.type ? options.type : "gifs";
var GiphyFetch = class {
  constructor(apiKey, qsParams = {}) {
    this.getQS = (options = {}) => {
      const searchParams = new URLSearchParams(__spreadValues(__spreadProps(__spreadValues({}, options), {
        api_key: this.apiKey,
        pingback_id: get_pingback_id_default()
      }), this.qsParams));
      return searchParams.toString();
    };
    this.apiKey = apiKey;
    this.qsParams = qsParams;
  }
  /**
   * A list of categories
   *
   * @param {CategoriesOptions} [options]
   * @returns {Promise<CategoriesResult>}
   */
  categories(options) {
    return request_default(`gifs/categories?${this.getQS(options)}`);
  }
  /**
   * Get a single gif by a id
   * @param {string} id
   * @returns {Promise<GifsResult>}
   **/
  gif(id, options) {
    const prefix = (options == null ? void 0 : options.internal) ? "internal/" : "";
    return request_default(`${prefix}gifs/${id}?${this.getQS()}`, { normalizer: normalizeGif });
  }
  gifs(arg1, arg2) {
    if (Array.isArray(arg1)) {
      return request_default(`gifs?${this.getQS({ ids: arg1.join(",") })}`, {
        normalizer: normalizeGifs
      });
    }
    return request_default(`gifs/categories/${arg1}/${arg2}?${this.getQS()}`, {
      normalizer: normalizeGifs
    });
  }
  emoji(options) {
    return request_default(`emoji?${this.getQS(options)}`, { normalizer: normalizeGifs });
  }
  /**
   * Returns a list of all the default emoji variations
   *
   * @param {PaginationOptions} options
   * @returns {Promise<GifsResult>}
   **/
  emojiDefaultVariations(options) {
    return request_default(`emoji?${this.getQS(options)}`, {
      apiVersion: 2,
      normalizer: normalizeGifs
    });
  }
  /**
   * Returns a list of gifs representing all the variations for the emoji
   *
   * @param {string} id
   * @returns {Promise<NonPaginatedGifsResult>}
   **/
  emojiVariations(id) {
    return request_default(`emoji/${id}/variations?${this.getQS()}`, {
      apiVersion: 2,
      normalizer: normalizeGifs
    });
  }
  animate(text, options = {}) {
    const qsParams = this.getQS(__spreadProps(__spreadValues({}, options), { m: text }));
    return request_default(`text/animate?${qsParams}`, { normalizer: normalizeGifs });
  }
  /**
   * @param term: string The term you're searching for
   * @param options: SearchOptions
   * @returns {Promise<GifsResult>}
   **/
  search(term, options = {}) {
    const q = options.channel ? `@${options.channel} ${term}` : term;
    let excludeDynamicResults;
    if (options.type === "text") {
      excludeDynamicResults = true;
    }
    const qsParams = this.getQS(__spreadProps(__spreadValues({ rating: "pg-13" }, options), { q, excludeDynamicResults }));
    return request_default(`${getType(options)}/search?${qsParams}`, { normalizer: normalizeGifs });
  }
  /**
   * Get a list of subcategories
   * @param {string} category
   * @param {SubcategoriesOptions} options
   * @returns {Promise<CategoriesResult>}
   */
  subcategories(category, options) {
    return request_default(`gifs/categories/${category}?${this.getQS(options)}`);
  }
  /**
   * Get trending gifs
   *
   * @param {TrendingOptions} options
   * @returns {Promise<GifsResult>}
   */
  trending(options = {}) {
    return request_default(`${getType(options)}/trending?${this.getQS(__spreadValues({ rating: "pg-13" }, options))}`, {
      normalizer: normalizeGifs
    });
  }
  /**
   * Get a random gif
   * @param {RandomOptions} options
   * @returns {Promise<GifResult>}
   **/
  random(options) {
    return request_default(`${getType(options)}/random?${this.getQS(__spreadValues({ rating: "pg-13" }, options))}`, {
      noCache: true,
      normalizer: normalizeGif
    });
  }
  /**
   * Get related gifs by a id
   * @param {string} id
   * @param {SubcategoriesOptions} options
   * @returns {Promise<GifsResult>}
   **/
  related(id, options = {}) {
    const { type = "gifs" } = options;
    return request_default(
      `${type}/related?${this.getQS(__spreadValues({
        gif_id: id,
        rating: "pg-13"
      }, options))}`,
      { normalizer: normalizeGifs }
    );
  }
  /**
   * Search for channels based on a term
   * @param {string} term
   * @param options: SearchOptions
   * @returns {Promise<ChannelsResult>}
   **/
  channels(term, options = {}) {
    return request_default(
      `channels/search?${this.getQS(__spreadValues({ q: term, rating: "pg-13" }, options))}`
    );
  }
};
var api_default = GiphyFetch;
var gifPaginator = (fetchGifs, initialGifs = []) => {
  const gifs = [...initialGifs];
  const gifIds = initialGifs.map((g) => g.id);
  let offset = initialGifs.length;
  let isDoneFetching = false;
  return () => __async(void 0, null, function* () {
    if (isDoneFetching) {
      return gifs;
    }
    const result = yield fetchGifs(offset);
    const { pagination, data: newGifs } = result;
    offset = pagination.count + pagination.offset;
    isDoneFetching = offset === pagination.total_count;
    newGifs.forEach((gif) => {
      const { id } = gif;
      if (!gifIds.includes(id)) {
        gifs.push(gif);
        gifIds.push(id);
      }
    });
    return [...gifs];
  });
};
var _a;
if (typeof __require2 !== "undefined") {
  const { version } = require_package();
  if (!((_a = getGiphySDKRequestHeaders()) == null ? void 0 : _a.get(`X-GIPHY-SDK-NAME`))) {
    appendGiphySDKRequestHeader(`X-GIPHY-SDK-NAME`, "FetchAPI");
    appendGiphySDKRequestHeader(`X-GIPHY-SDK-VERSION`, version);
  }
}
export {
  fetch_error_default as FetchError,
  GeoFetchError,
  api_default as GiphyFetch,
  gifPaginator,
  request_default as request,
  serverUrl,
  setServerUrl
};
//# sourceMappingURL=@giphy_js-fetch-api.js.map
